require('dotenv').config(); // Panggil paling atas untuk memuat file .env
const webpush = require('web-push');
const express = require('express');
const cors = require('cors');
const { testConnection } = require('./config/database');
const authRoutes = require('./routes/authRoutes'); // Impor rute auth
const adminRoutes = require('./routes/adminRoutes'); //impor rute admin
const jadwalRoutes = require('./routes/jadwalRoutes'); //impor rute jadwal
const izinRoutes = require('./routes/izinRoutes'); //impor rute izin
const userRoutes = require('./routes/userRoutes');
const santriRoutes = require('./routes/santriRoutes'); //impor rute data santri
const notificationRoutes = require('./routes/notificationRoutes');
// ## TAMBAHKAN BARIS INI UNTUK MENGIMPOR SERVICE BARU ##
const reminderService = require('./services/reminderService');

const app = express();
const PORT = 3000;

// Konfigurasi ini harus ada setelah impor dan sebelum rute
webpush.setVapidDetails(
  'mailto:ismafzyyh@gmail.com', // email administratif
  process.env.VAPID_PUBLIC_KEY,
  process.env.VAPID_PRIVATE_KEY
);
// ----------------------------------------------------


app.use(express.static('public')); //untuk membaca code frontend

// Middleware
const corsOptions = {
    origin: 'https://penjemputan-ppum.site', // agar backend hanya menerima request dari domain
    optionsSuccessStatus: 200
};
app.use(cors(corsOptions));
app.use(express.json()); // Membaca body request sebagai JSON

// Jalankan fungsi tes koneksi
testConnection();

app.use('/api/auth', authRoutes); // Semua rute di authRoutes akan diawali '/api/auth'
app.use('/api/admin', adminRoutes);
app.use('/api/jadwal', jadwalRoutes);
app.use('/api/izin', izinRoutes);
app.use('/api/user', userRoutes);
app.use('/api/v1/santri', santriRoutes);
app.use('/api/notifications', notificationRoutes); //rute notifikasi

app.get('/', (req, res) => {
  res.send('Server penjemputan santri sudah berjalan.');
});

reminderService.startReminderService();

app.listen(PORT, () => {
  console.log(`Server berhasil berjalan di http://localhost:${PORT}`);
});