// Mengimpor library mysql2/promise untuk menggunakan async/await
const mysql = require('mysql2/promise');

// Mengimpor library dotenv untuk membaca file .env
const dotenv = require('dotenv');
dotenv.config(); // Memuat semua variabel dari file .env

// Membuat koneksi pool ke database
const pool = mysql.createPool({
  host: process.env.DB_HOST,
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0
});

// Fungsi untuk mengetes koneksi
async function testConnection() {
  try {
    const connection = await pool.getConnection();
    console.log('✅ Berhasil terhubung ke database MySQL!');
    connection.release(); // Melepaskan koneksi kembali ke pool
  } catch (error) {
    console.error('❌ Gagal terhubung ke database:', error.message);
  }
}

// Mengekspor pool dan fungsi tes agar bisa digunakan di file lain
module.exports = { pool, testConnection };