const nodemailer = require('nodemailer');

const sendEmail = async (options) => {
    // Buat transporter (menggunakan detail server dari Rumahweb)
    const transporter = nodemailer.createTransport({
        host: process.env.EMAIL_HOST,    // Server SMTP Rumahweb
        port: process.env.EMAIL_PORT,    // Port SMTP (biasanya 465)
        secure: true, // true untuk port 465, false untuk port lain
        auth: {
            user: process.env.EMAIL_USER, // Email yang baru Anda buat
            pass: process.env.EMAIL_PASS  // Password email tersebut
        }
    });

    // Tentukan opsi email
    const mailOptions = {
        from: `Sistem Penjemputan <${process.env.EMAIL_USER}>`,
        to: options.email,
        subject: options.subject,
        html: options.message
    };

    // Kirim email
    await transporter.sendMail(mailOptions);
};

module.exports = sendEmail;