const { pool } = require('../config/database');

exports.createIzin = async (req, res) => {
    const { jadwal_id, santri_id, username_penjemput } = req.body;
    const user_id_wali_sah = req.user.id; // Wali yang sedang login

    try {
        const connection = await pool.getConnection();
        await connection.beginTransaction();

        // Verifikasi bahwa santri ini adalah milik wali sah
        const [santriOwner] = await connection.query('SELECT * FROM santri WHERE santri_id = ? AND user_id = ?', [santri_id, user_id_wali_sah]);
        if (santriOwner.length === 0) {
            await connection.rollback();
            return res.status(403).json({ message: 'Akses ditolak: Anda bukan wali sah dari santri ini.' });
        }

        // Cari user_id dari wali penjemput berdasarkan username
        const [penjemput] = await connection.query('SELECT id FROM users WHERE username = ? AND role = "orang_tua"', [username_penjemput]);
        if (penjemput.length === 0) {
            await connection.rollback();
            return res.status(404).json({ message: `User dengan username '${username_penjemput}' tidak ditemukan.` });
        }
        const user_id_penjemput = penjemput[0].id;

        // Masukkan data izin ke database
        await connection.query(
            `INSERT INTO izin_penjemputan (jadwal_id, santri_id, user_id_wali_sah, user_id_penjemput) VALUES (?, ?, ?, ?)`,
            [jadwal_id, santri_id, user_id_wali_sah, user_id_penjemput]
        );

        await connection.commit();
        res.status(201).json({ message: `Izin berhasil diberikan kepada ${username_penjemput}.` });

    } catch (error) {
        console.error(error);
        res.status(500).json({ message: 'Terjadi kesalahan pada server.' });
    }
};