const { pool } = require('../config/database');
const webpush = require('web-push');

// Fungsi untuk menyediakan VAPID public key ke frontend
exports.getVapidPublicKey = (req, res) => {
    if (!process.env.VAPID_PUBLIC_KEY) {
        return res.status(500).send('VAPID Public Key belum diatur di server.');
    }
    res.status(200).send(process.env.VAPID_PUBLIC_KEY);
};

// Fungsi untuk menyimpan langganan notifikasi dari user
exports.subscribe = async (req, res) => {
    const subscription = req.body;
    const userId = req.user.id; // Diambil dari token JWT

    try {
        // Hapus langganan lama jika ada, untuk menghindari duplikat
        await pool.query('DELETE FROM push_subscriptions WHERE user_id = ?', [userId]);

        // Simpan detail langganan baru ke database
        await pool.query(
            'INSERT INTO push_subscriptions (user_id, endpoint, p256dh, auth) VALUES (?, ?, ?, ?)',
            [userId, subscription.endpoint, subscription.keys.p256dh, subscription.keys.auth]
        );
        res.status(201).json({ message: 'Langganan notifikasi berhasil.' });
    } catch (error) {
        console.error('Gagal menyimpan langganan:', error);
        res.status(500).json({ message: 'Gagal menyimpan langganan.' });
    }
};