const { pool } = require('../config/database');

// FUNGSI Mendapatkan Semua Data Santri
exports.getAllSantri = async (req, res) => {
    try {
        const [santriList] = await pool.query(
            `SELECT 
                s.santri_id, s.nama_santri, s.nisn, s.satuan_pendidikan,
                s.hubungan_wali, ot.nama_wali, ot.no_telp, ot.alamat,
                ot.username AS username_wali
             FROM santri s
             JOIN users ot ON s.user_id = ot.id
             ORDER BY s.nama_santri ASC`
        );
        res.status(200).json(santriList);
    } catch (error) {
        console.error(error);
        res.status(500).json({ message: 'Terjadi kesalahan pada server.' });
    }
};

// FUNGSI Mengambil Detail Satu Santri berdasarkan NISN
exports.getSantriByNisn = async (req, res) => {
    try {
        const { nisn } = req.params;
        const [santri] = await pool.query(
            `SELECT s.*, ot.nama_wali 
             FROM santri s 
             JOIN users ot ON s.user_id = ot.id 
             WHERE s.nisn = ?`,
            [nisn]
        );
        if (santri.length === 0) {
            return res.status(404).json({ message: 'Data santri tidak ditemukan.' });
        }
        res.status(200).json(santri[0]);
    } catch (error) {
        console.error(error);
        res.status(500).json({ message: 'Terjadi kesalahan pada server.' });
    }
};

// FUNGSI Mengedit Data Santri
exports.updateSantri = async (req, res) => {
    try {
        const { nisn } = req.params;
        const { nama_santri, satuan_pendidikan, hubungan_wali } = req.body;
        if (!nama_santri || !satuan_pendidikan || !hubungan_wali) {
            return res.status(400).json({ message: 'Semua kolom wajib diisi.' });
        }
        const [result] = await pool.query(
            'UPDATE santri SET nama_santri = ?, satuan_pendidikan = ?, hubungan_wali = ? WHERE nisn = ?',
            [nama_santri, satuan_pendidikan, hubungan_wali, nisn]
        );
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: 'Data santri tidak ditemukan.' });
        }
        res.status(200).json({ message: `Data santri dengan NISN ${nisn} berhasil diperbarui.` });
    } catch (error) {
        console.error(error);
        res.status(500).json({ message: 'Terjadi kesalahan pada server.' });
    }
};

// FUNGSI Menghapus Data Santri
exports.deleteSantri = async (req, res) => {
    try {
        const { nisn } = req.params;
        const [result] = await pool.query('DELETE FROM santri WHERE nisn = ?', [nisn]);
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: 'Data santri tidak ditemukan.' });
        }
        res.status(200).json({ message: `Data santri dengan NISN ${nisn} berhasil dihapus.` });
    } catch (error) {
        console.error(error);
        res.status(500).json({ message: 'Terjadi kesalahan pada server.' });
    }
};