const jwt = require('jsonwebtoken');
const { pool } = require('../config/database');

// apakah user sudah login (membawa token valid)
const protect = async (req, res, next) => {
    let token;

    if (req.headers.authorization && req.headers.authorization.startsWith('Bearer')) {
        try {
            // Ambil token dari header
            token = req.headers.authorization.split(' ')[1];

            // Verifikasi token
            const decoded = jwt.verify(token, process.env.JWT_SECRET);

            // Simpan data user dari token ke object req agar bisa dipakai di controller
            req.user = decoded;

            next(); // Lanjutkan ke proses selanjutnya
        } catch (error) {
            console.error(error);
            res.status(401).json({ message: 'Tidak terotorisasi, token gagal' });
        }
    }

    if (!token) {
        res.status(401).json({ message: 'Tidak terotorisasi, tidak ada token' });
    }
};

// Middleware untuk memeriksa apakah user adalah admin
const isAdmin = (req, res, next) => {
    if (req.user && req.user.role === 'admin') {
        next(); // Lanjutkan jika rolenya adalah admin
    } else {
        res.status(403).json({ message: 'Akses ditolak, butuh peran Admin' });
    }
};

module.exports = { protect, isAdmin };