document.addEventListener('DOMContentLoaded', () => {
    //Ambil semua elemen dari halaman
    const tableBody = document.getElementById('santri-table-body');
    const selectAllCheckbox = document.getElementById('select-all-checkbox');
    const editButton = document.getElementById('edit-button');
    const deleteButton = document.getElementById('delete-button');
    const paginationInfo = document.getElementById('pagination-info');
    const filterButton = document.getElementById('filter-button');
    const filterDropdown = document.getElementById('filter-dropdown');
    //Ambil semua elemen dari MODAL EDIT
    const editModal = document.getElementById('edit-santri-modal');
    const closeEditModalButton = document.getElementById('close-edit-modal-button');
    const batalEditButton = document.getElementById('batal-edit-button');
    const editForm = document.getElementById('edit-santri-form');
    //Ambil semua elemen dari MODAL HAPUS
    const deleteModal = document.getElementById('delete-modal');
    const closeDeleteModalButton = document.getElementById('close-delete-modal-button');
    const batalDeleteButton = document.getElementById('batal-delete-button');
    const konfirmasiDeleteButton = document.getElementById('konfirmasi-delete-button');
    const deleteModalText = document.getElementById('delete-modal-text');
    //elemen notifikasi
    const notificationModal = document.getElementById('notification-modal');
    const notificationIcon = document.getElementById('notification-icon');
    const notificationTitle = document.getElementById('notification-title');
    const notificationMessage = document.getElementById('notification-message');
    const closeNotificationButton = document.getElementById('close-notification-button');

    const showNotification = (type, title, message) => {
        if (!notificationModal) return;
        notificationIcon.classList.remove('bg-green-500', 'bg-red-500');
        if (type === 'success') {
            notificationIcon.innerHTML = `<i class="fas fa-check text-4xl text-white"></i>`;
            notificationIcon.classList.add('bg-green-500');
            notificationTitle.textContent = title || 'Berhasil!';
        } else {
            notificationIcon.innerHTML = `<i class="fas fa-times text-4xl text-white"></i>`;
            notificationIcon.classList.add('bg-red-500');
            notificationTitle.textContent = title || 'Gagal!';
        }
        notificationMessage.textContent = message;
        notificationModal.classList.remove('hidden');
    };

    const closeNotification = () => {
        if (notificationModal) notificationModal.classList.add('hidden');
    };

    if (closeNotificationButton) {
        closeNotificationButton.addEventListener('click', closeNotification);
    }
    // Variabel untuk menyimpan data
    let allSantriData = [];
    let selectedNisns = [];

    function updateButtonStates() {
      const selectedCount = selectedNisns.length;
      editButton.disabled = selectedCount !== 1;
      editButton.className = selectedCount === 1 ? 'action-button' : 'action-button-disabled';
      deleteButton.disabled = selectedCount === 0;
      if (selectedCount > 0) {
          deleteButton.className = 'action-button bg-white text-red-600 border border-gray-300 hover:bg-red-600 hover:text-white';
      } else {
          deleteButton.className = 'action-button-disabled';
      }
    }
    function renderTable(santriList) {
      if (!santriList || santriList.length === 0) {
          tableBody.innerHTML = '<tr><td colspan="8" class="text-center p-4">Tidak ada data santri yang cocok.</td></tr>';
          paginationInfo.textContent = 'Menampilkan 0 data';
          return;
      }
      tableBody.innerHTML = santriList.map(santri => `
          <tr class="border-b hover:bg-gray-50">
              <td class="p-3"><input type="checkbox" class="row-checkbox" data-nisn="${santri.nisn}"></td>
              <td class="p-3">${santri.nisn || '-'}</td>
              <td class="p-3 font-medium text-gray-800">${santri.nama_santri || '-'}</td>
              <td class="p-3">${santri.satuan_pendidikan || '-'}</td>
              <td class="p-3">${santri.hubungan_wali || '-'}</td>
              <td class="p-3">${santri.nama_wali || '-'}</td>
              <td class="p-3">${santri.no_telp || '-'}</td>
              <td class="p-3">${santri.alamat || '-'}</td>
          </tr>
      `).join('');
      paginationInfo.textContent = `Menampilkan ${santriList.length} dari ${allSantriData.length} data`;
    }
    function applyFilter(filterValue) {
      let filteredList = allSantriData;
      if (filterValue !== 'Semua') {
          filteredList = allSantriData.filter(santri => santri.satuan_pendidikan === filterValue);
      }
      renderTable(filteredList);
      selectedNisns = [];
      updateButtonStates();
      selectAllCheckbox.checked = false;
    }

    // Fungsi untuk mengambil semua data dari server
    async function fetchAllSantri() {
        try {
            allSantriData = await fetchWithAuth('/api/v1/santri');
            renderTable(allSantriData);
        } catch (error) {
            console.error('Gagal mengambil data santri:', error.message);
            if (error.message !== 'Sesi berakhir') {
                tableBody.innerHTML = `<tr><td colspan="8" class="text-center p-4">Gagal memuat data. Silakan coba lagi.</td></tr>`;
                paginationInfo.textContent = 'Gagal memuat data';
            }
        }
    }
    async function openEditModal(nisn) {
        try {
            const santri = await fetchWithAuth(`/api/v1/santri/${nisn}`);
            document.getElementById('edit-nama-santri').value = santri.nama_santri;
            document.getElementById('edit-nisn').value = santri.nisn;
            document.getElementById('edit-satuan-pendidikan').value = santri.satuan_pendidikan;
            document.getElementById('edit-hubungan-wali').value = santri.hubungan_wali;
            editModal.classList.remove('hidden');
        } catch (error) {
            console.error(error.message);
            if (error.message !== 'Sesi berakhir') {
                showNotification('error', 'Gagal!', 'Gagal memuat data untuk diedit.');
            }
        }
    }

    function closeEditModal() {
        editModal.classList.add('hidden');
        editForm.reset();
    }

    async function handleUpdateSantri(event) {
        event.preventDefault();
        const nisnToUpdate = document.getElementById('edit-nisn').value;
        const updatedData = {
            nama_santri: document.getElementById('edit-nama-santri').value,
            satuan_pendidikan: document.getElementById('edit-satuan-pendidikan').value,
            hubungan_wali: document.getElementById('edit-hubungan-wali').value,
        };
        try {
            await fetchWithAuth(`/api/v1/santri/${nisnToUpdate}`, {
                method: 'PUT',
                body: JSON.stringify(updatedData)
            });
            showNotification('success', 'Berhasil!', 'Data santri berhasil diperbarui.');
            closeEditModal();
            await fetchAllSantri();
            selectedNisns = [];
            updateButtonStates();
        } catch (error) {
            console.error(error);
            if (error.message !== 'Sesi berakhir') {
                showNotification('error', 'Gagal!',`Gagal memperbarui data: ${error.message}`);
            }
        }
    }

    // LOGIKA MODAL HAPUS
    function openDeleteModal() {
        if (selectedNisns.length > 0) {
            deleteModalText.textContent = `Apakah anda yakin ingin menghapus ${selectedNisns.length} data santri terpilih?`;
            deleteModal.classList.remove('hidden');
        }
    }

    function closeDeleteModal() {
        deleteModal.classList.add('hidden');
    }

    async function handleDeleteSantri() {
        let deleteCount = 0;
        let failedCount = 0;
        const deletePromises = selectedNisns.map(nisn => {
            return fetchWithAuth(`/api/v1/santri/${nisn}`, { method: 'DELETE' })
                .then(() => deleteCount++)
                .catch(error => {
                    failedCount++;
                    console.error(`Gagal menghapus santri dengan NISN ${nisn}:`, error.message);
                });
        });
    
        await Promise.all(deletePromises);
    
        showNotification('success', 'Berhasil!',`${deleteCount} dari ${selectedNisns.length} data santri berhasil dihapus.`);
        if(failedCount > 0) {
            showNotification('error', 'Gagal!',`${failedCount} data gagal dihapus. Lihat konsol untuk detail.`);
        }

        closeDeleteModal();
        await fetchAllSantri(); // Muat ulang data
        selectedNisns = [];
        updateButtonStates();
    }
    filterButton.addEventListener('click', () => {
      filterDropdown.classList.toggle('hidden');
    });
    filterDropdown.addEventListener('click', (event) => {
      event.preventDefault();
      if (event.target.classList.contains('filter-option')) {
          const filterValue = event.target.dataset.filter;
          applyFilter(filterValue);
          filterDropdown.classList.add('hidden');
      }
    });
    document.addEventListener('click', (event) => {
      if (!filterButton.contains(event.target) && !filterDropdown.contains(event.target)) {
          filterDropdown.classList.add('hidden');
      }
    });
    tableBody.addEventListener('change', event => {
      if (event.target.classList.contains('row-checkbox')) {
          const nisn = event.target.dataset.nisn;
          if (event.target.checked) {
              selectedNisns.push(nisn);
          } else {
              selectedNisns = selectedNisns.filter(id => id !== nisn);
          }
          selectAllCheckbox.checked = tableBody.querySelectorAll('.row-checkbox:checked').length === tableBody.querySelectorAll('.row-checkbox').length;
          updateButtonStates();
      }
    });
    selectAllCheckbox.addEventListener('change', event => {
      const allCheckboxes = tableBody.querySelectorAll('.row-checkbox');
      selectedNisns = [];
      allCheckboxes.forEach(checkbox => {
          checkbox.checked = event.target.checked;
          if (event.target.checked) {
              selectedNisns.push(checkbox.dataset.nisn);
          }
      });
      updateButtonStates();
    });
    editButton.addEventListener('click', () => {
      if (selectedNisns.length === 1) {
          openEditModal(selectedNisns[0]);
      }
    });
    deleteButton.addEventListener('click', openDeleteModal);
    closeEditModalButton.addEventListener('click', closeEditModal);
    batalEditButton.addEventListener('click', closeEditModal);
    editForm.addEventListener('submit', handleUpdateSantri);
    closeDeleteModalButton.addEventListener('click', closeDeleteModal);
    batalDeleteButton.addEventListener('click', closeDeleteModal);
    konfirmasiDeleteButton.addEventListener('click', handleDeleteSantri);

    // Panggil fungsi utama saat halaman dimuat
    fetchAllSantri();
});