document.addEventListener('DOMContentLoaded', () => {
    // Amankan halaman
    checkAdminLogin();

    // Ambil elemen dari HTML
    const mainTitle = document.getElementById('main-title');
    const jadwalInfoCard = document.getElementById('jadwal-info-card');
    const sesiTableBody = document.getElementById('sesi-table-body');

    // Fungsi untuk mendapatkan ID dari URL
    function getJadwalIdFromUrl() {
        const params = new URLSearchParams(window.location.search);
        return params.get('id');
    }

    // Fungsi untuk memuat dan menampilkan data
    async function loadJadwalDetail() {
        const jadwalId = getJadwalIdFromUrl();
        if (!jadwalId) {
            mainTitle.textContent = 'ID Jadwal Tidak Ditemukan';
            return;
        }

        try {
            const data = await fetchWithAuth(`/api/admin/jadwal/${jadwalId}/detail`);
            
            // Tampilkan Info Utama Jadwal
            mainTitle.textContent = `Detail Jadwal ${data.jenis_jadwal}`;
            jadwalInfoCard.innerHTML = `
                <p class="text-lg font-bold text-gray-800">${dayjs(data.tgl_jemput).format('dddd, D MMMM YYYY')}</p>
                <p class="text-gray-600">${data.satuan_pendidikan}</p>
                <p class="text-gray-600">${data.waktu_mulai.slice(0, 5)} - ${data.waktu_selesai.slice(0, 5)} WITA</p>
            `;

            // Tampilkan Tabel Sesi
            sesiTableBody.innerHTML = ''; // Kosongkan tabel dulu
            if (data.sesi && data.sesi.length > 0) {
                data.sesi.forEach(sesi => {
                    const statusClass = sesi.status_ketersediaan === 'Penuh' ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800';
                    const row = document.createElement('tr');
                    row.className = 'border-b hover:bg-gray-50 cursor-pointer';
                    // Simpan ID sesi di elemen baris untuk event click
                    row.dataset.sesiId = sesi.sesi_id;

                    row.innerHTML = `
                        <td class="p-3 font-medium">${sesi.nomor_sesi}</td>
                        <td class="p-3">${sesi.waktu_mulai.slice(0, 5)} - ${sesi.waktu_selesai.slice(0, 5)}</td>
                        <td class="p-3">${sesi.santri_terdaftar} / ${sesi.kapasitas_santri_total}</td>
                        <td class="p-3">${sesi.reguler_terpakai} / ${sesi.kapasitas_reguler}</td>
                        <td class="p-3">${sesi.prioritas_terpakai} / ${sesi.kapasitas_prioritas}</td>
                        <td class="p-3">
                            <span class="px-2 py-1 font-semibold leading-tight text-xs rounded-full ${statusClass}">
                                ${sesi.status_ketersediaan}
                            </span>
                        </td>
                    `;
                    
                    // Tambahkan event listener agar baris bisa diklik
                    row.addEventListener('click', () => {
                        const timeRange = `${sesi.waktu_mulai.slice(0,5)}-${sesi.waktu_selesai.slice(0,5)}`;
                        window.location.href = `/admin-detail-sesi.html?id=${sesi.sesi_id}&jadwalId=${data.jadwal_id}&date=${data.tgl_jemput}&time=${timeRange}`;
                    });

                    sesiTableBody.appendChild(row);
                });
            } else {
                sesiTableBody.innerHTML = '<tr><td colspan="6" class="p-4 text-center text-gray-500">Tidak ada sesi untuk jadwal ini.</td></tr>';
            }

        } catch (error)
        {
            console.error('Gagal memuat detail jadwal:', error);
            mainTitle.textContent = 'Gagal Memuat Data';
            sesiTableBody.innerHTML = `<tr><td colspan="6" class="p-4 text-center text-red-500">${error.message}</td></tr>`;
        }
    }

    loadJadwalDetail();
});