document.addEventListener('DOMContentLoaded', () => {
    checkAdminLogin();

    const mainTitle = document.getElementById('main-title');
    const pendaftarTableBody = document.getElementById('pendaftar-table-body');
    const backButton = document.getElementById('back-button');

    function getInfoFromUrl() {
        const params = new URLSearchParams(window.location.search);
        return {
            sesiId: params.get('id'),
            jadwalId: params.get('jadwalId'),
            time: params.get('time'),
            date: params.get('date')
        };
    }

    async function loadSesiDetail() {
        const { sesiId, jadwalId, time, date } = getInfoFromUrl();

        if (!sesiId || !jadwalId) {
            mainTitle.textContent = 'Informasi Sesi Tidak Lengkap';
            return;
        }

        backButton.href = `/admin-detail-jadwal.html?id=${jadwalId}`;
        
        const formattedDate = dayjs(date).format('D MMMM YYYY');
        // KODE BARU
        const formattedTime = time || '';
        mainTitle.textContent = `Detail Pendaftar Sesi (${formattedTime} - ${formattedDate})`;

        try {
            const data = await fetchWithAuth(`/api/admin/sesi/${sesiId}/pendaftar`);
            
            pendaftarTableBody.innerHTML = '';
            if (data && data.length > 0) {
                data.forEach(pendaftar => {
                    const jalurClass = pendaftar.jalur_digunakan === 'prioritas' 
                        ? 'bg-blue-200 text-blue-700' 
                        : 'bg-gray-100 text-gray-800';
                    
                    const row = document.createElement('tr');
                    row.className = 'border-b';
                    row.innerHTML = `
                        <td class="p-3 font-medium">${pendaftar.nama_penjemput}</td>
                        <td class="p-3">${pendaftar.nama_santri}</td>
                        <td class="p-3">${pendaftar.hubungan || '-'}</td>
                        <td class="p-3 capitalize">${pendaftar.jenis_kendaraan}</td>
                        <td class="p-3">
                            <span class="px-2 py-1 font-semibold leading-tight text-xs rounded-full ${jalurClass}">
                                ${pendaftar.jalur_digunakan}
                            </span>
                        </td>
                    `;
                    pendaftarTableBody.appendChild(row);
                });
            } else {
                pendaftarTableBody.innerHTML = '<tr><td colspan="5" class="p-4 text-center text-gray-500">Belum ada pendaftar di sesi ini.</td></tr>';
            }

        } catch (error) {
            console.error('Gagal memuat detail sesi:', error);
            mainTitle.textContent = 'Gagal Memuat Data';
            pendaftarTableBody.innerHTML = `<tr><td colspan="5" class="p-4 text-center text-red-500">${error.message}</td></tr>`;
        }
    }

    loadSesiDetail();
});