document.addEventListener('DOMContentLoaded', () => {
    // Pastikan user sudah login sebagai admin, jika tidak, tendang ke halaman login
    checkAdminLogin(); 

    const form = document.getElementById('change-password-form');
    const messageContainer = document.getElementById('message-container');
    const submitButton = document.getElementById('submit-button');

    form.addEventListener('submit', async (e) => {
        e.preventDefault();

        // Ambil nilai dari form
        const currentPassword = document.getElementById('currentPassword').value;
        const newPassword = document.getElementById('newPassword').value;
        const confirmPassword = document.getElementById('confirmPassword').value;

        // Reset pesan error/sukses
        messageContainer.classList.add('hidden');
        messageContainer.textContent = '';
        if (!currentPassword || !newPassword || !confirmPassword) {
            showMessage('Semua kolom wajib diisi.', 'error');
            return;
        }
        if (newPassword !== confirmPassword) {
            showMessage('Password baru dan konfirmasi tidak cocok.', 'error');
            return;
        }
        if (newPassword.length < 6) {
            showMessage('Password baru minimal harus 6 karakter.', 'error');
            return;
        }

        // Nonaktifkan tombol selama proses
        submitButton.disabled = true;
        submitButton.textContent = 'Menyimpan...';

        try {
            const token = localStorage.getItem('token');
            const response = await fetch('/api/admin/change-password', {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${token}`
                },
                body: JSON.stringify({
                    currentPassword,
                    newPassword,
                    confirmPassword
                })
            });

            const data = await response.json();

            if (response.ok) {
                showMessage(data.message, 'success');
                form.reset(); // Kosongkan form setelah berhasil
            } else {
                // Tampilkan pesan error dari server
                showMessage(data.message || 'Gagal memperbarui password.', 'error');
            }

        } catch (error) {
            console.error('Error:', error);
            showMessage('Terjadi kesalahan koneksi ke server.', 'error');
        } finally {
            // Aktifkan kembali tombol
            submitButton.disabled = false;
            submitButton.textContent = 'Simpan Perubahan';
        }
    });

    function showMessage(message, type) {
        messageContainer.textContent = message;
        messageContainer.classList.remove('hidden', 'bg-red-100', 'text-red-700', 'bg-green-100', 'text-green-700');
        
        if (type === 'error') {
            messageContainer.classList.add('bg-red-100', 'text-red-700');
        } else {
            messageContainer.classList.add('bg-green-100', 'text-green-700');
        }
    }
});