function initKelolaJadwalPage() {
    const notificationModal = document.getElementById('notification-modal');
    const notificationIcon = document.getElementById('notification-icon');
    const notificationTitle = document.getElementById('notification-title');
    const notificationMessage = document.getElementById('notification-message');
    const closeNotificationButton = document.getElementById('close-notification-button');

    const showNotification = (type, title, message) => {
        if (!notificationModal) return;
        notificationIcon.classList.remove('bg-green-500', 'bg-red-500', 'bg-yellow-500', 'bg-blue-500');
        notificationIcon.innerHTML = '';
        if (type === 'success') {
            notificationIcon.innerHTML = `<i class="fas fa-check text-4xl text-white"></i>`;
            notificationIcon.classList.add('bg-green-500');
            notificationTitle.textContent = title || 'Berhasil!';
        } else if (type === 'warning') {
            notificationIcon.innerHTML = `<i class="fas fa-info-circle text-4xl text-white"></i>`;
            notificationIcon.classList.add('bg-yellow-500');
            notificationTitle.textContent = title || 'Berhasil dengan Catatan!';
        } else if (type === 'info') {
            notificationIcon.innerHTML = `<i class="fas fa-info-circle text-4xl text-white"></i>`;
            notificationIcon.classList.add('bg-green-500');
            notificationTitle.textContent = title || 'Informasi';
        } else {
            notificationIcon.innerHTML = `<i class="fas fa-times text-4xl text-white"></i>`;
            notificationIcon.classList.add('bg-red-500');
            notificationTitle.textContent = title || 'Gagal!';
        }
        notificationMessage.textContent = message;
        notificationModal.classList.remove('hidden');
    };
    const closeNotification = () => {
        if (notificationModal) notificationModal.classList.add('hidden');
    };
    if (closeNotificationButton) {
        closeNotificationButton.addEventListener('click', closeNotification);
    }

    // Inisialisasi Choices.js
    let choices = null;
    const satuanPendidikanElement = document.getElementById('satuan_pendidikan');
    if (satuanPendidikanElement) {
        if (satuanPendidikanElement.choices) {
            satuanPendidikanElement.choices.destroy();
        }
        choices = new Choices(satuanPendidikanElement, {
            removeItemButton: true,
            placeholder: true,
            placeholderValue: 'Pilih satu atau lebih jenjang'
        });
    }

    const tableBody = document.getElementById('jadwal-table-body');
    const tabPenjemputan = document.getElementById('tab-penjemputan');
    const tabKembali = document.getElementById('tab-kembali');
    const selectAllCheckbox = document.getElementById('select-all-checkbox');
    const paginationInfo = document.getElementById('pagination-info');
    const editButton = document.getElementById('edit-button');
    const deleteButton = document.getElementById('delete-button');
    const tambahButton = document.getElementById('tambah-button');
    const sortButton = document.getElementById('sort-button');
    const sortDropdown = document.getElementById('sort-dropdown');
    const modal = document.getElementById('jadwal-modal');
    const modalTitle = document.getElementById('modal-title');
    const closeModalButton = document.getElementById('close-modal-button');
    const batalButton = document.getElementById('batal-button');
    const konfirmasiButton = document.getElementById('konfirmasi-button');
    const jadwalForm = document.getElementById('jadwal-form');
    const deleteModal = document.getElementById('delete-modal');
    const deleteCloseModalButton = document.getElementById('delete-close-modal-button');
    const deleteBatalButton = document.getElementById('delete-batal-button');
    const deleteKonfirmasiButton = document.getElementById('delete-konfirmasi-button');
    const deleteModalText = document.getElementById('delete-modal-text');

    let allJadwal = [];
    let currentTab = 'penjemputan';
    let currentSort = 'terbaru';

    const openModal = (mode = 'tambah', data = null) => {
        jadwalForm.reset();
        document.getElementById('tgl_jemput').min = new Date().toISOString().split("T")[0];
        if (mode === 'edit' && data) {
            modalTitle.textContent = 'Edit Jadwal';
            konfirmasiButton.textContent = 'Simpan Perubahan';
            document.getElementById('jadwal-id').value = data.jadwal_id;
            document.getElementById('tgl_jemput').value = dayjs(data.tgl_jemput).format('YYYY-MM-DD');
            document.getElementById('jenis_jadwal').value = data.jenis_jadwal;
            if (choices) {
                choices.clearStore();
                const satuanPendidikanArray = data.satuan_pendidikan.split(', ');
                choices.setValue(satuanPendidikanArray);
            }
            document.getElementById('jumlah_santri').value = data.total_santri_dijadwalkan;
            document.getElementById('waktu_mulai').value = data.waktu_mulai.substring(0, 5);
            document.getElementById('waktu_selesai').value = data.waktu_selesai.substring(0, 5);
            document.getElementById('jumlah_loket').value = data.jumlah_loket;
            document.getElementById('jumlah_sesi').value = data.jumlah_sesi;
        } else {
            modalTitle.textContent = 'Tambah Jadwal';
            konfirmasiButton.textContent = 'Konfirmasi';
            document.getElementById('jadwal-id').value = '';
        }
        modal.classList.remove('hidden');
    };
    const closeModal = () => modal.classList.add('hidden');
    const openDeleteModal = (count) => {
        deleteModalText.textContent = `Apakah Anda yakin ingin menghapus ${count} jadwal terpilih?`;
        deleteModal.classList.remove('hidden');
    };
    const closeDeleteModal = () => deleteModal.classList.add('hidden');

    const handleFormSubmit = async (event) => {
        event.preventDefault(); 
        const formData = new FormData(jadwalForm);
        const data = {
            tgl_jemput: formData.get('tgl_jemput'),
            jenis_jadwal: formData.get('jenis_jadwal'),
            satuan_pendidikan: formData.getAll('satuan_pendidikan'),
            jumlah_santri: formData.get('jumlah_santri'),
            waktu_mulai: formData.get('waktu_mulai'),
            waktu_selesai: formData.get('waktu_selesai'),
            jumlah_loket: formData.get('jumlah_loket'),
            jumlah_sesi: formData.get('jumlah_sesi'),
        };
        const jadwalId = formData.get('jadwal_id');
        const method = jadwalId ? 'PUT' : 'POST';
        const url = jadwalId ? `/api/admin/jadwal/${jadwalId}` : '/api/admin/jadwal';
        try {
            const responseData = await fetchWithAuth(url, {
                method: method,
                body: JSON.stringify(data)
            });
            const pesanUtama = responseData.message;
            const pesanFeedback = responseData.feedback.message;
            const tipeFeedback = responseData.feedback.type;
            showNotification(tipeFeedback, pesanUtama, pesanFeedback);
            closeModal();
            fetchJadwal();
        } catch (error) {
            console.error(error.message);
            if (error.message !== 'Sesi berakhir') {
                showNotification('error', 'Gagal!', error.message);
            }
        }
    };

    const renderTable = () => {
        let filteredJadwal = allJadwal.filter(j => j.jenis_jadwal === currentTab);
        filteredJadwal.sort((a, b) => {
            const dateA = new Date(a.tgl_jemput);
            const dateB = new Date(b.tgl_jemput);
            return currentSort === 'terbaru' ? dateB - dateA : dateA - dateB;
        });
        tableBody.innerHTML = '';
        paginationInfo.textContent = `Menampilkan ${filteredJadwal.length} data`;
        if (filteredJadwal.length === 0) {
            tableBody.innerHTML = `<tr><td colspan="8" class="text-center p-4 text-gray-500">Tidak ada jadwal untuk kategori ini.</td></tr>`;
            return;
        }
        filteredJadwal.forEach(jadwal => {
            const row = document.createElement('tr');
            row.className = 'border-b hover:bg-gray-50 cursor-pointer';

            row.innerHTML = `
                <td class="p-3"><input type="checkbox" class="row-checkbox" data-id="${jadwal.jadwal_id}"></td>
                <td class="p-3 font-medium">${dayjs(jadwal.tgl_jemput).format('DD MMMM YYYY')}</td>
                <td class="p-3">${jadwal.satuan_pendidikan}</td>
                <td class="p-3">${jadwal.total_santri_dijadwalkan}</td>
                <td class="p-3">${jadwal.waktu_mulai.substring(0,5)} - ${jadwal.waktu_selesai.substring(0,5)}</td>
                <td class="p-3">${jadwal.jumlah_loket || '-'}</td>
                <td class="p-3">${jadwal.jumlah_sesi}</td>
                <td class="p-3 capitalize">${jadwal.jenis_jadwal}</td>
            `;
            row.addEventListener('click', (e) => {
                if (e.target.tagName.toLowerCase() !== 'input') {
                    window.location.href = `/admin-detail-jadwal.html?id=${jadwal.jadwal_id}`;
                }
            });
            tableBody.appendChild(row);
        });
    };

    const fetchJadwal = async () => {
        try {
            allJadwal = await fetchWithAuth('/api/admin/all-jadwal');
            renderTable();
            updateActionButtons();
        } catch (error) {
            console.error(error.message);
            if (error.message !== 'Sesi berakhir') {
                tableBody.innerHTML = `<tr><td colspan="8" class="text-center p-4 text-red-500">Gagal memuat data.</td></tr>`;
            }
        }
    };

    const updateActionButtons = () => {
        const selectedCheckboxes = document.querySelectorAll('.row-checkbox:checked');
        const count = selectedCheckboxes.length;
        deleteButton.disabled = count === 0;
        deleteButton.className = count > 0 ? 'action-button-danger' : 'action-button-disabled';
        editButton.disabled = count !== 1;
        editButton.className = count === 1 ? 'action-button' : 'action-button-disabled';
    };

    const setupEventListeners = () => {
        konfirmasiButton.removeEventListener('click', handleFormSubmit);
        jadwalForm.removeEventListener('submit', handleFormSubmit);

        if(tambahButton) tambahButton.onclick = () => openModal('tambah');
        if(closeModalButton) closeModalButton.onclick = closeModal;
        if(batalButton) batalButton.onclick = closeModal;
        konfirmasiButton.addEventListener('click', handleFormSubmit);
        jadwalForm.addEventListener('submit', handleFormSubmit);


        if(editButton) editButton.onclick = () => {
            const selectedCheckbox = document.querySelector('.row-checkbox:checked');
            if (selectedCheckbox) {
                const id = selectedCheckbox.dataset.id;
                const dataToEdit = allJadwal.find(j => j.jadwal_id == id);
                openModal('edit', dataToEdit);
            }
        };
        
        if(deleteButton) deleteButton.onclick = () => {
            const selectedCheckboxes = document.querySelectorAll('.row-checkbox:checked');
            if (selectedCheckboxes.length > 0) {
                openDeleteModal(selectedCheckboxes.length);
            }
        };

        if(deleteKonfirmasiButton) deleteKonfirmasiButton.onclick = async () => {
            const selectedCheckboxes = document.querySelectorAll('.row-checkbox:checked');
            const idsToDelete = Array.from(selectedCheckboxes).map(cb => cb.dataset.id);
            if (idsToDelete.length > 0) {
                try {
                    const deletePromises = idsToDelete.map(id => 
                        fetchWithAuth(`/api/admin/jadwal/${id}`, { method: 'DELETE' })
                    );
                    await Promise.all(deletePromises);
                    showNotification('success', 'Berhasil!', 'Jadwal yang dipilih berhasil dihapus.');
                    closeDeleteModal();
                    fetchJadwal();
                } catch (error) {
                    console.error(error.message);
                    if (error.message !== 'Sesi berakhir') {
                        showNotification('error', 'Gagal!', 'Beberapa jadwal mungkin gagal dihapus.');
                    }
                }
            }
        };

        if(deleteCloseModalButton) deleteCloseModalButton.onclick = closeDeleteModal;
        if(deleteBatalButton) deleteBatalButton.onclick = closeDeleteModal;

        if(tabPenjemputan) tabPenjemputan.onclick = () => {
            currentTab = 'penjemputan';
            tabPenjemputan.classList.add('active');
            tabKembali.classList.remove('active');
            if(selectAllCheckbox) selectAllCheckbox.checked = false;
            renderTable();
            updateActionButtons();
        };

        if(tabKembali) tabKembali.onclick = () => {
            currentTab = 'kembali';
            tabKembali.classList.add('active');
            tabPenjemputan.classList.remove('active');
            if(selectAllCheckbox) selectAllCheckbox.checked = false;
            renderTable();
            updateActionButtons();
        };

        if(tableBody) tableBody.onchange = (e) => {
            if (e.target.classList.contains('row-checkbox')) {
                updateActionButtons();
            }
        };

        if(selectAllCheckbox) selectAllCheckbox.onchange = (e) => {
            document.querySelectorAll('.row-checkbox').forEach(checkbox => { checkbox.checked = e.target.checked; });
            updateActionButtons();
        };
        
        if(sortButton) sortButton.onclick = (e) => {
            e.stopPropagation();
            sortDropdown.classList.toggle('hidden');
        };

        if(sortDropdown) sortDropdown.onclick = (e) => {
            e.preventDefault();
            if (e.target.classList.contains('sort-option')) {
                currentSort = e.target.dataset.sort;
                renderTable();
                sortDropdown.classList.add('hidden');
            }
        };

        document.onclick = (e) => {
            if (sortButton && !sortButton.contains(e.target) && sortDropdown && !sortDropdown.contains(e.target)) {
                sortDropdown.classList.add('hidden');
            }
        };
    }

    // Inisialisasi tidak diubah
    setupEventListeners();
    fetchJadwal();
}

// LOGIKA PEMUATAN HALAMAN
document.addEventListener('DOMContentLoaded', () => {
    // Verifikasi login admin
    checkAdminLogin();
    
    // Jalankan semua logika halaman untuk pertama kali
    initKelolaJadwalPage(); 
});

window.addEventListener('pageshow', (event) => {
    if (event.persisted) {
        console.log('Halaman dimuat dari cache, menjalankan ulang semua logika interaktif.');
        initKelolaJadwalPage();
    }
});