function parseJwt(token) {
    try {
        const base64Url = token.split('.')[1];
        const base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/');
        const jsonPayload = decodeURIComponent(atob(base64).split('').map(function(c) {
            return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
        }).join(''));
        return JSON.parse(jsonPayload);
    } catch (e) {
        return null;
    }
}

async function fetchWithAuth(url, options = {}) {
    const token = localStorage.getItem('token');

    //Diagnostik untuk mencetak info pengguna di frontend
    if (token) {
        const userPayload = parseJwt(token);
        console.log('%c[FRONTEND] Mengirim permintaan sebagai:', 'color: blue; font-weight: bold;', userPayload);
    } else {
        console.log('%c[FRONTEND] Tidak ada token yang dikirim.', 'color: orange; font-weight: bold;');
    }
    const cacheBustURL = new URL(url, window.location.origin);
    cacheBustURL.searchParams.append('_cacheBust', new Date().getTime());

    const headers = {
        'Content-Type': 'application/json',
        ...options.headers,
    };

    if (token) {
        headers['Authorization'] = `Bearer ${token}`;
    }

    try {
        const response = await fetch(cacheBustURL.toString(), {
            ...options,
            headers: headers,
            cache: 'no-store'
        });

        if (response.status === 401 || response.status === 403) {
            localStorage.removeItem('token');
            alert('Sesi Anda telah berakhir. Silakan login kembali.');
            window.location.href = '/index.html';
            throw new Error('Sesi berakhir'); 
        }

        if (!response.ok) {
            const errorData = await response.json();
            throw new Error(errorData.message || 'Terjadi kesalahan pada server');
        }
        
        const text = await response.text();
        return text ? JSON.parse(text) : null;

    } catch (error) {
        throw error;
    }

    // Komentar: Fungsi ini akan memeriksa token yang aktif dan memastikan
    // perannya sesuai dengan yang diharapkan oleh halaman.
    function checkRoleAndRedirect(expectedRole) {
        const token = localStorage.getItem('token');
        if (token) {
            const payload = parseJwt(token);

            // Cek jika peran di token TIDAK SAMA DENGAN peran yang diharapkan
            if (payload && payload.role !== expectedRole) {
                console.warn(`Peran tidak sesuai. Diharapkan '${expectedRole}', ditemukan '${payload.role}'. Mengarahkan...`);
                
                // Arahkan ke dashboard yang benar sesuai peran di token
                const destination = payload.role === 'admin' ? '/admin-dashboard.html' : '/user-dashboard.html';
                window.location.replace(destination);
                
                return false; // Beri sinyal bahwa redirect terjadi, eksekusi skrip harus berhenti
            }
        } else if (expectedRole !== 'guest') { 
            // Jika halaman butuh login tapi tidak ada token, paksa ke halaman login
            // (Ini untuk keamanan tambahan)
            console.warn('Tidak ada token. Mengarahkan ke halaman login...');
            window.location.replace('/login.html');
            return false;
        }

        return true; 
    }

}