//PENJAGA HALAMAN ADMIN dipanggil di setiap halaman admin untuk memastikan hanya admin yang sudah login yang bisa mengaksesnya.
function checkAdminLogin() {
    const token = localStorage.getItem('token');
    
    // Jika tidak ada token sama sekali
    if (!token) {
        console.log('Tidak ada token, mengarahkan ke halaman login.');
        window.location.replace('/index.html');
        return; 
    }

    try {
        // Jika ada token, coba baca isinya
        const payload = parseJwt(token);
        
        // Jika token tidak valid atau rolenya bukan admin
        if (!payload || payload.role !== 'admin') {
            console.log('Token tidak valid atau bukan admin, mengarahkan ke halaman login.');
            localStorage.removeItem('token'); 
            window.location.replace('/index.html');
            return;
        }
        
        // Jika semua aman, biarkan user tetap di halaman
        console.log('Admin terverifikasi.');

    } catch (e) {
        console.error('Error saat memverifikasi token:', e);
        localStorage.removeItem('token');
        window.location.replace('/index.html');
    }
}

document.addEventListener('DOMContentLoaded', () => {
    
    // ## FUNGSI BARU: PENERJEMAH TOKEN (JWT) 
    function parseJwt(token) {
        try {
            const base64Url = token.split('.')[1];
            const base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/');
            const jsonPayload = decodeURIComponent(atob(base64).split('').map(function(c) {
                return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
            }).join(''));
            return JSON.parse(jsonPayload);
        } catch (e) {
            return null;
        }
    }

    // Fungsi untuk menampilkan pesan error di halaman login
    function showError(message) {
        const errorMessageDiv = document.getElementById('errorMessage');
        if (errorMessageDiv) {
            errorMessageDiv.querySelector('span').textContent = message;
            errorMessageDiv.classList.remove('hidden');
        }
    }

    // LOGIKA UNTUK HALAMAN LOGIN
    const loginForm = document.getElementById('loginForm');
    if (loginForm) {
        const loginIdentifierInput = document.getElementById('username');
        const passwordInput = document.getElementById('password');
        const loginButton = document.getElementById('loginButton');
        const togglePasswordButton = document.getElementById('togglePassword');

        if (togglePasswordButton) {
            togglePasswordButton.addEventListener('click', () => {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                const icon = togglePasswordButton.querySelector('i');
                // Ganti kelas ikon berdasarkan tipe input
                icon.className = type === 'password' ? 'fas fa-eye-slash' : 'fas fa-eye';
             });
        }

        loginForm.addEventListener('submit', async (event) => {
            event.preventDefault();
            localStorage.removeItem('token'); // Selalu bersihkan token lama
            const loginIdentifier = loginIdentifierInput.value;
            const password = passwordInput.value;
            
            loginButton.textContent = 'Loading...';
            loginButton.disabled = true;

            try {
                const response = await fetch('/api/auth/login', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ loginIdentifier, password }),
                });
                
                const data = await response.json();
                if (!response.ok) {
                    showError(data.message || 'Terjadi kesalahan.');
                    return;
                }
                
                localStorage.setItem('token', data.token);
                const payload = parseJwt(data.token);

                if (!payload) {
                    throw new Error('Token tidak valid.');
                }

                if (payload.role === 'admin') {
                    window.location.replace('/admin-dashboard.html');
                } else {
                    window.location.replace('/user-dashboard.html');
                }
            } catch (error) {
                console.error('Login error:', error);
                showError('Tidak dapat terhubung ke server.');
            } finally {
                loginButton.textContent = 'Masuk';
                loginButton.disabled = false;
            }
        });
    }
    const token = localStorage.getItem('token');
    if (!loginForm && !token) {
        console.log('Sesi tidak ditemukan, mengarahkan ke halaman login.');
        window.location.replace('/index.html');
        return;
    }

    const logoutButton = document.getElementById('logoutButton');
    const logoutModal = document.getElementById('logout-modal');

    if (logoutButton && logoutModal) {
        const confirmLogoutButton = document.getElementById('confirm-logout-button');
        const cancelLogoutButton = document.getElementById('cancel-logout-button');
        const closeLogoutModalButton = document.getElementById('close-logout-modal-button');

        const performLogout = async () => {
            console.log('Memulai proses logout total...');
            localStorage.removeItem('token');
            try {
                if ('serviceWorker' in navigator) {
                    const registration = await navigator.serviceWorker.getRegistration();
                    if (registration) {
                        await registration.unregister();
                        console.log('Service Worker berhasil di-unregister.');
                    }
                }
                if ('caches' in window) {
                    const keys = await caches.keys();
                    await Promise.all(keys.map(key => caches.delete(key)));
                    console.log('Semua cache berhasil dihapus.');
                }
            } catch (error) {
                console.error('Gagal melakukan pembersihan total saat logout:', error);
            }
            window.location.replace('/index.html');
        };

        logoutButton.addEventListener('click', () => {
            logoutModal.classList.remove('hidden');
        });
        if(confirmLogoutButton) confirmLogoutButton.addEventListener('click', performLogout);
        if(cancelLogoutButton) cancelLogoutButton.addEventListener('click', () => logoutModal.classList.add('hidden'));
        if(closeLogoutModalButton) closeLogoutModalButton.addEventListener('click', () => logoutModal.classList.add('hidden'));
    }
});