document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('forgot-password-form');
    const emailInput = document.getElementById('email');
    const submitButton = document.getElementById('submit-button');
    const infoText = document.getElementById('info-text');

    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        const email = emailInput.value;
        
        submitButton.disabled = true;
        submitButton.textContent = 'Mengirim...';

        try {
            const response = await fetch('/api/auth/forgot-password', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ email })
            });

            const data = await response.json();

            // Apapun responsnya, tampilkan pesan yang sama untuk keamanan
            infoText.textContent = data.message;
            infoText.classList.add('text-green-600', 'font-semibold');
            form.reset();
            emailInput.disabled = true; // Nonaktifkan input setelah berhasil
            submitButton.classList.add('bg-gray-400', 'hover:bg-gray-400'); // Ubah warna tombol
            submitButton.textContent = 'Terkirim';

        } catch (error) {
            console.error('Error:', error);
            infoText.textContent = 'Terjadi kesalahan. Silakan coba lagi.';
            infoText.classList.add('text-red-600', 'font-semibold');
            submitButton.disabled = false;
            submitButton.textContent = 'Kirim Tautan Reset Kata Sandi';
        }
    });
});

