document.addEventListener('DOMContentLoaded', () => {
    const registerForm = document.getElementById('registerForm');
    const errorMessage = document.getElementById('errorMessage');
    const successMessage = document.getElementById('successMessage');

    // Fungsi untuk menampilkan pesan
    const showMessage = (element, message) => {
        element.textContent = message;
        element.classList.remove('hidden');
    };

    // Fungsi untuk menyembunyikan pesan
    const hideMessages = () => {
        errorMessage.classList.add('hidden');
        successMessage.classList.add('hidden');
    };

    // Logika untuk tombol "Daftar"
    registerForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        hideMessages();

        const username = document.getElementById('username').value;
        const email = document.getElementById('email').value;
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirmPassword').value;

        // Validasi frontend
        if (password !== confirmPassword) {
            showMessage(errorMessage, 'Password dan konfirmasi password tidak cocok.');
            return;
        }

        try {
            const response = await fetch('/api/auth/register', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ username, email, password }),
            });

            const data = await response.json();

            if (!response.ok) {
                // Tampilkan pesan error dari backend
                throw new Error(data.message || 'Terjadi kesalahan');
            }

            // Tampilkan pesan sukses dan arahkan ke halaman login
            showMessage(successMessage, data.message + ' Anda akan diarahkan ke halaman login...');
            setTimeout(() => {
                window.location.href = '/login.html';
            }, 3000); // Tunggu 3 detik sebelum redirect

        } catch (error) {
            showMessage(errorMessage, error.message);
        }
    });

    // Logika untuk Show/Hide Password
const togglePasswordVisibility = (inputId, buttonId) => {
    const passwordInput = document.getElementById(inputId);
    const toggleButton = document.getElementById(buttonId);

    toggleButton.addEventListener('click', () => {
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);

        const icon = toggleButton.querySelector('i');
        // Ganti kelas ikon berdasarkan tipe input
        icon.className = type === 'password' ? 'fas fa-eye-slash' : 'fas fa-eye';
    });
};

    togglePasswordVisibility('password', 'togglePassword');
    togglePasswordVisibility('confirmPassword', 'toggleConfirmPassword');
});

