document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('reset-password-form');
    const passwordInput = document.getElementById('password');
    const confirmPasswordInput = document.getElementById('confirmPassword');
    const submitButton = document.getElementById('submit-button');
    const infoText = document.getElementById('info-text');

    // Ambil token dari parameter URL (?token=...)
    const urlParams = new URLSearchParams(window.location.search);
    const token = urlParams.get('token');

    if (!token) {
        infoText.textContent = 'Token reset tidak ditemukan atau tidak valid.';
        infoText.classList.add('text-red-600', 'font-semibold');
        form.style.display = 'none'; // Sembunyikan form jika tidak ada token
        return;
    }

    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        const password = passwordInput.value;
        const confirmPassword = confirmPasswordInput.value;

        if (password !== confirmPassword) {
            infoText.textContent = 'Password dan konfirmasi tidak cocok.';
            infoText.classList.remove('text-green-600');
            infoText.classList.add('text-red-600', 'font-semibold');
            return;
        }

        submitButton.disabled = true;
        submitButton.textContent = 'Memproses...';

        try {
            const response = await fetch(`/api/auth/reset-password/${token}`, {
                method: 'PUT',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ password, confirmPassword })
            });

            const data = await response.json();

            if (!response.ok) {
                throw new Error(data.message || 'Gagal mereset password.');
            }
            
            infoText.textContent = data.message;
            infoText.classList.remove('text-red-600');
            infoText.classList.add('text-green-600', 'font-semibold');
            form.style.display = 'none'; // Sembunyikan form setelah berhasil
            
            // Tambahkan link untuk kembali ke login setelah berhasil
            const loginLink = document.createElement('a');
            loginLink.href = '/index.html';
            loginLink.className = 'block text-center mt-4 text-green-600 hover:underline';
            loginLink.textContent = 'Kembali ke Halaman Login';
            form.parentElement.appendChild(loginLink);

        } catch (error) {
            console.error('Error:', error);
            infoText.textContent = error.message;
            infoText.classList.add('text-red-600', 'font-semibold');
            submitButton.disabled = false;
            submitButton.textContent = 'Reset Password';
        }
    });
});

