document.addEventListener('DOMContentLoaded', () => {
    const backButton = document.getElementById('back-button');
    const santriListContainer = document.getElementById('santri-list-container');
    const izinForm = document.getElementById('izin-form');
    const usernameInput = document.getElementById('username-penjemput');
    const suksesModal = document.getElementById('sukses-modal');
    const suksesModalText = document.getElementById('sukses-modal-text');
    const tutupSuksesModalBtn = document.getElementById('tutup-sukses-modal');

    const urlParams = new URLSearchParams(window.location.search);
    const jadwalId = urlParams.get('jadwal_id');

    if (!jadwalId) {
        alert('ID Jadwal tidak valid.');
        window.history.back();
        return;
    }
    
    backButton.href = `/user-pilihan-sesi.html?id=${jadwalId}`;

    async function loadMySantri() {
        try {
            const mySantri = await fetchWithAuth('/api/user/santri');
            if (mySantri.length > 0) {
                santriListContainer.innerHTML = mySantri.map(santri => `
                    <label class="p-3 border rounded-lg flex items-center cursor-pointer hover:bg-gray-50">
                        <input type="checkbox" name="santri_ids" value="${santri.santri_id}" class="mr-3 h-5 w-5">
                        <span class="font-medium text-gray-800">${santri.nama_santri}</span>
                    </label>
                `).join('');
            } else {
                santriListContainer.innerHTML = '<p class="text-center text-gray-500">Anda belum mendaftarkan santri.</p>';
            }
        } catch (error) {
            console.error('Gagal memuat data santri:', error.message);
            if (error.message !== 'Sesi berakhir') {
                santriListContainer.innerHTML = '<p class="text-center text-red-500">Gagal memuat data santri.</p>';
            }
        }
    }
    
    async function handleFormSubmit(event) {
        event.preventDefault();
        const formData = new FormData(izinForm);
        const selectedSantriIds = formData.getAll('santri_ids');
        const usernamePenjemput = usernameInput.value.trim();

        if (selectedSantriIds.length === 0) {
            alert('Silakan pilih minimal satu santri untuk dititipkan.');
            return;
        }
        if (!usernamePenjemput) {
            alert('Silakan masukkan username wali penjemput.');
            return;
        }

        try {
            const promises = selectedSantriIds.map(santriId => {
                return fetchWithAuth('/api/izin/buat', { 
                    method: 'POST',
                    body: JSON.stringify({
                        jadwal_id: jadwalId,
                        santri_id: santriId,
                        username_penjemput: usernamePenjemput
                    })
                });
            });
            // Menunggu semua permintaan selesai
            await Promise.all(promises);
            
            suksesModalText.textContent = `${selectedSantriIds.length} santri berhasil dititipkan kepada ${usernamePenjemput}.`;
            suksesModal.classList.remove('hidden');

        } catch (error) {
            console.error(error.message);
            if (error.message !== 'Sesi berakhir') {
                alert(`Gagal memberikan izin: ${error.message}`);
            }
        }
    }

    tutupSuksesModalBtn.addEventListener('click', () => {
        suksesModal.classList.add('hidden');
        window.location.href = `/user-pilihan-sesi.html?id=${jadwalId}`;
    });

    izinForm.addEventListener('submit', handleFormSubmit);
    
    // Panggil fungsi utama
    loadMySantri();
});