document.addEventListener('DOMContentLoaded', () => {
    const jadwalContainer = document.getElementById('jadwal-container');
    const tabPenjemputan = document.getElementById('tab-penjemputan');
    const tabKembali = document.getElementById('tab-kembali');

    // Variabel global untuk menyimpan data dari server
    let allJadwals = {
        penjemputan: [],
        kembali: []
    };

    // FUNGSI createJadwalCard
    // Komentar: Fungsi ini sekarang memeriksa flag 'isRelevan' yang dikirim dari backend untuk menentukan apakah tombol harus aktif atau tidak.
    function createJadwalCard(jadwal) {
    const tanggal = dayjs(jadwal.tgl_jemput).format('dddd, D MMMM YYYY');
    
    const judul = jadwal.jenis_jadwal === 'penjemputan' 
        ? 'JADWAL PENJEMPUTAN' 
        : 'JADWAL KEMBALI KE PONDOK';

    const isRelevan = jadwal.isRelevan;

    const tagPembuka = isRelevan 
        ? `<a href="/user-pilihan-sesi.html?id=${jadwal.jadwal_id}" class="block bg-white p-4 rounded-lg shadow-sm border hover:shadow-md transition-shadow">`
        : `<div class="block bg-gray-100 p-4 rounded-lg shadow-sm border cursor-not-allowed opacity-60">`;
    
    const tagPenutup = isRelevan ? `</a>` : `</div>`;

    const tombol = isRelevan
        ? `<button class="bg-green-600 text-white font-semibold px-5 py-2 rounded-lg text-sm hover:bg-green-700">Lihat Sesi</button>`
        : `<button class="bg-gray-400 text-white font-semibold px-5 py-2 rounded-lg text-sm cursor-not-allowed" disabled>Lihat Sesi</button>`;

    return `
        ${tagPembuka}
            <div class="flex justify-between items-center">
                <div>
                    <p class="text-xs font-semibold text-gray-500">${judul}</p>
                    <h3 class="text-xl font-bold text-gray-800">${jadwal.satuan_pendidikan}</h3>
                    <p class="text-sm text-gray-500">${tanggal}</p>
                </div>
                ${tombol}
            </div>
        ${tagPenutup}
    `;
}

function displayJadwals(type) {
    const jadwalList = allJadwals[type];

    if (type === 'penjemputan') {
        tabPenjemputan.classList.add('active');
        tabKembali.classList.remove('active');
    } else {
        tabKembali.classList.add('active');
        tabPenjemputan.classList.remove('active');
    }

    if (!jadwalList || jadwalList.length === 0) {
        jadwalContainer.innerHTML = `<p class="text-center text-gray-500 py-4">Tidak ada jadwal yang tersedia saat ini.</p>`;
        return;
    }
    
    jadwalContainer.innerHTML = jadwalList.map(createJadwalCard).join('');
}

    // Komentar: Fungsi ini sekarang menerima objek yang berisi daftar jadwal penjemputan
    // dan kembali, yang masing-masing sudah ditandai dengan 'isRelevan' oleh backend.
    async function fetchJadwals() {
        try {
            const data = await fetchWithAuth('/api/jadwal/');

            allJadwals = {
                penjemputan: data.penjemputan,
                kembali: data.kembali
            };

            // Tampilkan jadwal penjemputan secara default
            displayJadwals('penjemputan');

        } catch (error) {
            console.error('Error memuat jadwal:', error.message);
            if (error.message !== 'Sesi berakhir') {
                jadwalContainer.innerHTML = `<p class="text-center text-gray-500 py-4">Gagal memuat jadwal. Silakan coba lagi.</p>`;
            }
        }
    }

    tabPenjemputan.addEventListener('click', () => displayJadwals('penjemputan'));
    tabKembali.addEventListener('click', () => displayJadwals('kembali'));

        // Fungsi utama untuk inisialisasi service worker dan push notification
    async function initializePushNotifications() {
        if (!('serviceWorker' in navigator) || !('PushManager' in window)) {
            console.warn('Push messaging tidak didukung oleh browser ini.');
            return;
        }
        try {
            const registration = await navigator.serviceWorker.register('/service-worker.js');
            console.log('Service Worker berhasil didaftarkan:', registration);
            await navigator.serviceWorker.ready;
            subscribeToPushNotifications(registration);
        } catch (error) {
            console.error('Pendaftaran Service Worker gagal:', error);
        }
    }

    // Fungsi untuk berlangganan push notification
    async function subscribeToPushNotifications(registration) {
        const existingSubscription = await registration.pushManager.getSubscription();
        if (existingSubscription) {
            console.log('Pengguna sudah berlangganan notifikasi.');
            return;
        }
        const permission = await window.Notification.requestPermission();
        if (permission !== 'granted') {
            console.log('Izin notifikasi tidak diberikan.');
            return;
        }
        // Kunci VAPID (kunci publik)
        const VAPID_PUBLIC_KEY = 'BDKE1oWC_bhkqStml-dZ_S3WfLamOGjVOMRnhMNCc3y23lkT7qbWDSUveJpgWlalLI0VvlvTG3V3eBXDgKNyWCY';
        try {
            const subscription = await registration.pushManager.subscribe({
                userVisibleOnly: true,
                applicationServerKey: VAPID_PUBLIC_KEY
            });
            console.log('Berhasil berlangganan:', subscription);
            await sendSubscriptionToServer(subscription);
        } catch (error) {
            console.error('Gagal berlangganan push notification:', error);
        }
    }

    // Fungsi untuk mengirim data langganan ke backend
    async function sendSubscriptionToServer(subscription) {
        try {
            await fetch('/api/notifications/subscribe', {
                method: 'POST',
                body: JSON.stringify(subscription),
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${localStorage.getItem('token')}`
                }
            });
            console.log('Subscription berhasil dikirim ke server.');
        } catch (error) {
            console.error('Gagal mengirim subscription ke server:', error);
        }
    }
  

    // Panggil fungsi utama saat halaman dimuat
    fetchJadwals();
    initializePushNotifications(); // Panggil fungsi notifikasi
});