document.addEventListener('DOMContentLoaded', () => {
    const notificationModal = document.getElementById('notification-modal');
    const notificationIcon = document.getElementById('notification-icon');
    const notificationTitle = document.getElementById('notification-title');
    const notificationMessage = document.getElementById('notification-message');
    const closeNotificationButton = document.getElementById('close-notification-button');

    const showNotification = (type, title, message) => {
        if (!notificationModal) return;
        notificationIcon.classList.remove('bg-green-500', 'bg-red-500');
        if (type === 'success') {
            notificationIcon.innerHTML = `<svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>`;
            notificationIcon.classList.add('bg-green-500');
            notificationTitle.textContent = title || 'Berhasil!';
        } else {
            notificationIcon.innerHTML = `<svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>`;
            notificationIcon.classList.add('bg-red-500');
            notificationTitle.textContent = title || 'Gagal!';
        }
        notificationMessage.textContent = message;
        notificationModal.classList.remove('hidden');
    };

    const closeNotification = () => {
        if (notificationModal) notificationModal.classList.add('hidden');
    };

    if (closeNotificationButton) {
        closeNotificationButton.addEventListener('click', closeNotification);
    }
    
    const form = document.getElementById('edit-profil-form');
    const namaWaliHeader = document.getElementById('nama-wali-header');
    const kontakWaliHeader = document.getElementById('kontak-wali-header');
    const santriContainer = document.getElementById('santri-fields-container');
    const tambahSantriBtn = document.getElementById('tambah-santri-btn');
    const santriTemplate = document.getElementById('santri-template');

    // Menyimpan santri_id saat memuat data
    function addSantriField(santriData = null) {
        const newSantriBlock = santriTemplate.firstElementChild.cloneNode(true);
        if (santriData) {
            newSantriBlock.querySelector('[name="santri_id"]').value = santriData.santri_id || '';

            newSantriBlock.querySelector('[name="nama_santri"]').value = santriData.nama_santri || '';
            newSantriBlock.querySelector('[name="nisn"]').value = santriData.nisn || '';
            newSantriBlock.querySelector('[name="satuan_pendidikan"]').value = santriData.satuan_pendidikan || 'SMA';
            newSantriBlock.querySelector('[name="hubungan_wali"]').value = santriData.hubungan_wali || '';
        }
        newSantriBlock.querySelector('.hapus-santri-btn').addEventListener('click', () => {
            newSantriBlock.remove();
        });
        santriContainer.appendChild(newSantriBlock);
    }

    async function loadProfileData() {
        try {
            const data = await fetchWithAuth('/api/user/profile');
            namaWaliHeader.textContent = data.nama_wali;
            kontakWaliHeader.textContent = `${data.email || ''} | ${data.no_telp || ''}`;
            document.getElementById('nama-wali').value = data.nama_wali;
            document.getElementById('email').value = data.email;
            document.getElementById('no-telp').value = data.no_telp;
            document.getElementById('alamat').value = data.alamat;
            santriContainer.innerHTML = '';
            if (data.santri && data.santri.length > 0) {
                data.santri.forEach(santri => addSantriField(santri));
            } else {
                addSantriField();
            }
        } catch (error) {
            console.error(error.message);
            if (error.message !== 'Sesi berakhir') {
                showNotification('error', 'Gagal Memuat Data', 'Tidak dapat mengambil data profil dari server. Silakan coba lagi.');
            }
        }
    }

    async function handleFormSubmit(event) {
        event.preventDefault();
        const simpanBtn = document.getElementById('simpan-btn-header');
        simpanBtn.disabled = true;
        simpanBtn.textContent = 'Menyimpan...';

        const santriBlocks = santriContainer.querySelectorAll('.santri-block');
        const santriData = Array.from(santriBlocks).map(block => ({
            santri_id: parseInt(block.querySelector('[name="santri_id"]').value, 10) || null,

            nama_santri: block.querySelector('[name="nama_santri"]').value.trim(),
            nisn: block.querySelector('[name="nisn"]').value.trim(),
            satuan_pendidikan: block.querySelector('[name="satuan_pendidikan"]').value,
            hubungan_wali: block.querySelector('[name="hubungan_wali"]').value.trim()
        }));
        
        const waliData = {
            nama_wali: document.getElementById('nama-wali').value.trim(),
            no_telp: document.getElementById('no-telp').value.trim(),
            alamat: document.getElementById('alamat').value.trim(),
            santri: santriData
        };

        try {
            await fetchWithAuth('/api/user/profile', {
                method: 'PUT',
                body: JSON.stringify(waliData)
            });
            
            showNotification('success', 'Berhasil!', 'Profil Anda telah berhasil diperbarui.');
            
            setTimeout(() => {
                window.location.href = '/user-profil.html';
            }, 1500);

        } catch (error) {
            console.error(error.message);
            if (error.message !== 'Sesi berakhir') {
                showNotification('error', 'Gagal Menyimpan', error.message);
            }
        } finally {
            simpanBtn.disabled = false;
            simpanBtn.textContent = 'Simpan';
        }
    }

    tambahSantriBtn.addEventListener('click', () => addSantriField());
    form.addEventListener('submit', handleFormSubmit);

    // Muat data saat halaman dibuka
    loadProfileData();
});
