document.addEventListener('DOMContentLoaded', () => {
    const notificationModal = document.getElementById('notification-modal');
    const notificationIcon = document.getElementById('notification-icon');
    const notificationTitle = document.getElementById('notification-title');
    const notificationMessage = document.getElementById('notification-message');
    const closeNotificationButton = document.getElementById('close-notification-button');

    const showNotification = (type, title, message) => {
        if (!notificationModal) return;
    notificationIcon.classList.remove('bg-green-500', 'bg-red-500'); 
    if (type === 'success') {
        notificationIcon.innerHTML = `<svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>`;
        notificationIcon.classList.add('bg-green-500');
        notificationTitle.textContent = title || 'Berhasil!';
    } else {
        notificationIcon.innerHTML = `<svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>`;
        notificationIcon.classList.add('bg-red-500');
        notificationTitle.textContent = title || 'Gagal!';
    }

        notificationMessage.textContent = message;
        notificationModal.classList.remove('hidden');
    };

    const closeNotification = () => {
        if (notificationModal) notificationModal.classList.add('hidden');
    };

    if (closeNotificationButton) {
        closeNotificationButton.addEventListener('click', closeNotification);
    }
    // LOGIKA FORM GANTI PASSWORD
    const form = document.getElementById('change-password-form');
    const currentPasswordInput = document.getElementById('current-password');
    const newPasswordInput = document.getElementById('new-password');
    const confirmNewPasswordInput = document.getElementById('confirm-new-password');
    const submitBtn = document.getElementById('submit-btn');

    async function handleChangePassword(event) {
        event.preventDefault();
        submitBtn.disabled = true;
        submitBtn.textContent = 'Memproses...';

        const currentPassword = currentPasswordInput.value;
        const newPassword = newPasswordInput.value;
        const confirmNewPassword = confirmNewPasswordInput.value;

        // Validasi frontend
        if (newPassword !== confirmNewPassword) {
            showNotification('error', 'Gagal', 'Password baru dan konfirmasi tidak cocok.');
            submitBtn.disabled = false;
            submitBtn.textContent = 'Ubah Kata Sandi';
            return;
        }

        try {
            const result = await fetchWithAuth('/api/user/change-password', {
                method: 'PUT',
                body: JSON.stringify({
                    currentPassword,
                    newPassword,
                    confirmNewPassword // Backend akan validasi ulang
                })
            });
            showNotification('success', 'Berhasil!', result.message || 'Password Anda telah berhasil diperbarui.');
            
            // Tunggu 1.5 detik sebelum mengarahkan ke halaman profil
            setTimeout(() => {
                window.location.href = '/user-profil.html';
            }, 1500);

        } catch (error) {
            console.error('Change password error:', error.message);
            if (error.message !== 'Sesi berakhir') {
                // Gunakan modal yang baru untuk menampilkan error dari server
                showNotification('error', 'Gagal', error.message);
            }
        } finally {
            // Tombol akan tetap nonaktif saat redirect, jadi ini opsional
            submitBtn.disabled = false;
            submitBtn.textContent = 'Ubah Kata Sandi';
        }
    }

    form.addEventListener('submit', handleChangePassword);
});