document.addEventListener('DOMContentLoaded', async () => {
    const namaWaliEl = document.getElementById('nama-wali');
    const kontakWaliEl = document.getElementById('kontak-wali');
    const mainContent = document.querySelector('.px-4.-mt-24');
    const logoutButton = document.getElementById('logoutButton');
    const logoutModal = document.getElementById('logout-modal');
    const closeLogoutModalButton = document.getElementById('close-logout-modal-button');
    const cancelLogoutButton = document.getElementById('cancel-logout-button');
    const confirmLogoutButton = document.getElementById('confirm-logout-button');

    const showError = () => {
        mainContent.innerHTML = `
            <div class="text-center mt-10">
                <h1 class="text-xl font-bold text-gray-700">Gagal memuat profil</h1>
                <p class="text-gray-500 mt-2">Silakan coba lagi nanti.</p>
            </div>
        `;
    };

    const renderProfile = (data) => {
        if (data && data.nama_wali) {
            namaWaliEl.textContent = data.nama_wali;
            const kontakParts = [];
            if (data.email) {
                kontakParts.push(data.email);
            }
            if (data.no_telp) {
                kontakParts.push(data.no_telp);
            }

            if (kontakParts.length > 0) {
                kontakWaliEl.textContent = kontakParts.join(' | ');
            } else {
                kontakWaliEl.textContent = 'Lengkapi info kontak Anda';
            }

        } else {
            namaWaliEl.textContent = 'Data Tidak Ditemukan';
            kontakWaliEl.textContent = 'Lengkapi profil Anda';
        }
    };

    try {
        const profileData = await fetchWithAuth('/api/user/profile'); 
        renderProfile(profileData);
    } catch (error) {
        console.error('Gagal memuat profil:', error.message);
        if (error.message !== 'Sesi berakhir') {
            showError();
        }
    }

    const openLogoutModal = () => logoutModal.classList.remove('hidden');
    const closeLogoutModal = () => logoutModal.classList.add('hidden');

    if (logoutButton) logoutButton.addEventListener('click', openLogoutModal);
    if (closeLogoutModalButton) closeLogoutModalButton.addEventListener('click', closeLogoutModal);
    if (cancelLogoutButton) cancelLogoutButton.addEventListener('click', closeLogoutModal);
    if (confirmLogoutButton) confirmLogoutButton.addEventListener('click', () => {
        localStorage.removeItem('token');
        window.location.href = '/login.html';
    });
});
