document.addEventListener('DOMContentLoaded', () => {
    const riwayatContainer = document.getElementById('riwayat-container');

    function createTypeIcon(jenisJadwal) {
        // Ikon untuk 'Kembali ke Pondok' (Masuk)
        if (jenisJadwal === 'kembali') {
            return `
                <div class="w-12 h-12 flex-shrink-0 bg-blue-100 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                </div>`;
        }
        // Ikon default untuk 'Penjemputan' (Keluar)
        return `
            <div class="w-12 h-12 flex-shrink-0 bg-green-100 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
            </div>`;
    }

    function createHistoryCard(item) {
        const tanggalSesi = dayjs(item.tgl_jemput).format('D MMMM YYYY');
        const waktuMulai = dayjs(item.waktu_mulai, 'HH:mm:ss').format('HH:mm');
        const waktuSelesai = dayjs(item.waktu_selesai, 'HH:mm:ss').format('HH:mm');
        const waktuSelesaiLengkap = dayjs(`${dayjs(item.tgl_jemput).format('YYYY-MM-DD')} ${item.waktu_selesai}`);
        const sekarang = dayjs();
        const isSelesai = sekarang.isAfter(waktuSelesaiLengkap);
        const statusBadge = isSelesai 
            ? `<span class="text-xs font-medium bg-green-100 text-green-700 px-2 py-1 rounded-full">Selesai</span>`
            : `<span class="text-xs font-medium bg-red-100 text-red-700 px-2 py-1 rounded-full">Belum Selesai</span>`;

        return `
            <div class="bg-white p-3 rounded-lg shadow-sm flex items-center space-x-4">
                <!-- ========================================================== -->
                <!-- ## PERUBAHAN UTAMA 2: PEMANGGILAN FUNGSI IKON ## -->
                <!-- Komentar: Sekarang kita memanggil 'createTypeIcon' dan mengirimkan -->
                <!-- 'item.jenis_jadwal' untuk mendapatkan ikon yang relevan. -->
                <!-- ========================================================== -->
                ${createTypeIcon(item.jenis_jadwal)}
                <div class="flex-1">
                    <h3 class="font-bold text-gray-800">${item.jenis_jadwal === 'kembali' ? 'Kembali ke Pondok' : 'Penjemputan'}</h3>
                    <p class="text-sm text-gray-600">${item.daftar_santri || 'Tidak ada santri'}</p>
                </div>
                <div class="text-right text-xs text-gray-500">
                    ${statusBadge}
                    <p class="font-semibold mt-1">${tanggalSesi}</p>
                    <p>${waktuMulai} - ${waktuSelesai}</p>
                </div>
            </div>
        `;
    }

    // Fungsi utama untuk memuat data riwayat
    async function loadHistory() {
        try {
            const historyList = await fetchWithAuth('/api/user/history');

            if (historyList.length === 0) {
                riwayatContainer.innerHTML = '<p class="text-center text-gray-500 pt-8">Anda belum memiliki riwayat penjemputan.</p>';
                return;
            }

            riwayatContainer.innerHTML = historyList.map(createHistoryCard).join('');

        } catch (error) {
            console.error('Error memuat riwayat:', error.message);
            if (error.message !== 'Sesi berakhir') {
                riwayatContainer.innerHTML = '<p class="text-center text-gray-500 pt-8">Gagal memuat riwayat. Silakan coba lagi.</p>';
            }
        }
    }

    loadHistory();
});
