const CACHE_NAME = 'sistem-penjemputan-cache-v4';
// Daftar file inti aplikasi yang akan disimpan di cache
const urlsToCache = [
    '/',
    '/index.html',
    '/style.css',
    
    // Semua file ikon baru
    '/img/favicon.ico',
    '/img/apple-touch-icon.png',
    '/img/favicon-16x16.png',
    '/img/favicon-32x32.png',
    '/img/android-chrome-192x192.png',
    '/img/android-chrome-512x512.png',
    '/img/app-icon-192x192.png', 
    '/img/app-icon-512x512.png',

    // Halaman & Skrip Umum
    '/lupa-password.html',
    '/reset-password.html',
    '/js/auth.js',
    '/js/lupa-password.js',
    '/js/reset-password.js',

    // Halaman & Skrip Admin
    '/admin-dashboard.html',
    '/admin-kelola-jadwal.html',
    '/admin-data-santri.html',
    '/js/admin-dashboard.js',
    '/js/admin-kelola-jadwal.js',
    '/js/admin-data-santri.js',

    // Halaman & Skrip User
    '/user-dashboard.html',
    '/user-pilihan-sesi.html',
    '/user-beri-izin.html',
    '/user-riwayat.html',
    '/user-profil.html',
    '/user-edit-profil.html',
    '/user-ganti-password.html',
    '/js/user-dashboard.js',
    '/js/user-pilihan-sesi.js',
    '/js/user-beri-izin.js',
    '/js/user-riwayat.js',
    '/js/user-profil.js',
    '/js/user-edit-profil.js',
    '/js/user-ganti-password.js'
];

// Event: Activate
self.addEventListener('activate', event => {
    // Logika untuk menghapus cache lama
    const cacheWhitelist = [CACHE_NAME];
    event.waitUntil(
        caches.keys().then(cacheNames => {
            return Promise.all(
                cacheNames.map(cacheName => {
                    if (cacheWhitelist.indexOf(cacheName) === -1) {
                        return caches.delete(cacheName);
                    }
                })
            );
        })
    );

    self.clients.claim(); 
});

self.addEventListener('install', event => {
    self.skipWaiting(); 
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then(cache => {
                console.log('Cache berhasil dibuka, menyimpan file inti...');
                return cache.addAll(urlsToCache);
            })
    );
});

self.addEventListener('fetch', event => {
    // Abaikan request selain GET
   // if (event.request.method !== 'GET') {
    //    return;
    //}

    // Cek apakah request adalah panggilan API (URL mengandung '/api/')
    if (event.request.url.includes('/api/')) {
        
        // UNTUK PANGGILAN API: SELALU AMBIL DARI JARINGAN, JANGAN PERNAH DARI CACHE.
    event.respondWith(fetch(event.request));
    return; // Hentikan eksekusi lebih lanjut
    } else {
        
        // Untuk Aset Statis Lainnya: Gunakan strategi Cache First
        event.respondWith(
            caches.match(event.request)
                .then(response => {
                    // Kembalikan dari cache jika ada, jika tidak, ambil dari jaringan
                    return response || fetch(event.request);
                })
        );
    }
});

// BAGIAN PUSH NOTIFICATION
// Event: 'push' - Berjalan ketika service worker menerima push message dari server
self.addEventListener('push', event => {
    console.log('Push message diterima!');
    
    // Ambil data notifikasi dari server (jika ada)
    const data = event.data.json();
    
    const title = data.title || 'Sistem Penjemputan';
    const options = {
        body: data.body || 'Anda memiliki pemberitahuan baru.',
        icon: '/img/android-chrome-192x192.png', // Ikon notifikasi
        badge: '/img/favicon-32x32.png' // Ikon kecil di status bar (opsional)
    };

    // Tampilkan notifikasi
    event.waitUntil(
        self.registration.showNotification(title, options)
    );
});

// Event: 'notificationclick' - Berjalan ketika pengguna mengklik notifikasi
self.addEventListener('notificationclick', event => {
    // Tutup notifikasi yang diklik
    event.notification.close();

    // Arahkan pengguna ke halaman utama aplikasi
    event.waitUntil(
        clients.openWindow('/')
    );
});