const express = require('express');
const router = express.Router();
const adminController = require('../controllers/adminController');
const santriController = require('../controllers/santriController');
const { protect, isAdmin } = require('../middleware/authMiddleware');

// === Rute Utama Admin ===
// Mendapatkan data untuk dashboard
router.get('/dashboard', protect, isAdmin, adminController.getDashboardData);
// Mendapatkan daftar semua user (orang tua)
router.get('/users', protect, isAdmin, adminController.getAllOrangTua);

router.put('/change-password', protect, isAdmin, adminController.changePassword);

// === Rute untuk Kelola Jadwal ===
// Mendapatkan semua jadwal untuk halaman manajemen
router.get('/all-jadwal', protect, isAdmin, adminController.getAllJadwalForManagement);
// Membuat jadwal baru
router.post('/jadwal', protect, isAdmin, adminController.createJadwal);
// Mengedit jadwal berdasarkan ID
router.put('/jadwal/:id', protect, isAdmin, adminController.updateJadwal);
// Menghapus jadwal berdasarkan ID
router.delete('/jadwal/:id', protect, isAdmin, adminController.deleteJadwal);

router.get('/jadwal/:jadwal_id/detail', protect, isAdmin, adminController.getJadwalDetail);
// Rute untuk mengambil detail pendaftar di sebuah sesi
// Alamatnya akan menjadi: GET /api/admin/sesi/5/detail (contoh)
router.get('/sesi/:sesi_id/detail', protect, isAdmin, adminController.getSesiDetail);

// Rute untuk detail pendaftar per santri (UNTUK HALAMAN DETAIL)
router.get('/sesi/:sesi_id/pendaftar', protect, isAdmin, adminController.getSesiPendaftarDetail);



module.exports = router;

