const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');

// Rute untuk Registrasi
// POST /api/auth/register
router.post('/register', authController.register);

// Rute untuk Login
// POST /api/auth/login
router.post('/login', authController.login);

// Rute untuk meminta token reset
router.post('/forgot-password', authController.forgotPassword);

// Rute untuk melakukan reset dengan token
router.put('/reset-password/:token', authController.resetPassword);

module.exports = router;