const express = require('express');
const router = express.Router();
const jadwalController = require('../controllers/jadwalController');
const { protect } = require('../middleware/authMiddleware');

// Rute untuk mendapatkan semua jadwal yang tersedia
// GET /api/jadwal
router.get('/', protect, jadwalController.getAllJadwal);

// Rute untuk mendapatkan detail satu jadwal beserta sesi-sesinya
// GET /api/jadwal/1  (contoh: 1 adalah id jadwal)
router.get('/:id', protect, jadwalController.getJadwalById);

// Rute untuk user memilih sesi
// POST /api/jadwal/pilih-sesi
router.post('/pilih-sesi', protect, jadwalController.pilihSesi); 

module.exports = router;