const express = require('express');
const router = express.Router();
const notificationController = require('../controllers/notificationController');
const { protect } = require('../middleware/authMiddleware'); // Middleware untuk memastikan user sudah login

// Rute untuk frontend mengambil VAPID Public Key
// Alamatnya akan menjadi: GET /api/notifications/vapid-public-key
router.get('/vapid-public-key', protect, notificationController.getVapidPublicKey);

// Rute untuk user berlangganan notifikasi
// Alamatnya akan menjadi: POST /api/notifications/subscribe
router.post('/subscribe', protect, notificationController.subscribe);

module.exports = router;