const express = require('express');
const router = express.Router();
const santriController = require('../controllers/santriController');
const { protect, isAdmin } = require('../middleware/authMiddleware');

// Rute ini akan menjadi '/api/v1/santri/' saat digabungkan di app.js
router.get('/', protect, isAdmin, santriController.getAllSantri);

// Rute ini akan menjadi '/api/v1/santri/:nisn'
router.get('/:nisn', protect, isAdmin, santriController.getSantriByNisn);

// Rute ini akan menjadi '/api/v1/santri/:nisn'
router.put('/:nisn', protect, isAdmin, santriController.updateSantri);

// Rute ini akan menjadi '/api/v1/santri/:nisn'
router.delete('/:nisn', protect, isAdmin, santriController.deleteSantri);

module.exports = router;