const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController');
const { protect } = require('../middleware/authMiddleware');

// Rute untuk mendapatkan daftar santri milik user
router.get('/santri', protect, userController.getMySantri);

// Rute untuk mendapatkan daftar santri yang bisa dijemput di jadwal tertentu
router.get('/santri-jemputan/:jadwal_id', protect, userController.getSantriForPickup);

// Rute untuk mengambil data profil
router.get('/profile', protect, userController.getProfile);

// Rute untuk memperbarui data profil
router.put('/profile', protect, userController.updateProfile);

// Rute untuk mengambil riwayat penjemputan
router.get('/history', protect, userController.getHistory);

// Rute untuk mengubah password
router.put('/change-password', protect, userController.changePassword);

module.exports = router;